/*    Foundation Window/Control Resource Editor Module  */
/*    Open Routines                                     */
#pragma noroot
#include <foundation.h>
#include <event.h>

void doOpen(fSessionRecPtr p)
{
word                retVal, retErr, windKind, action, tempVal, bad;
long                winTempID, procRef, hansize, *wkPtr, *edPtr;
Handle	            title, ctlHndl;
CtlRecHndl          tempCtl;
control             wkCtl;
fResLinkRec			parentRec;
WinTemplatePtr		edWin;

    switch (p->resType) {
        case rControlList:
        case rControlTemplate:
        case rCtlColorTbl:
        case rWindParam1:
        case rWindColor:
        case rMenuBar:
        case rMenu:
        case rMenuItem:
        {
            break;
        };
        default {
            return fErrTypeInvalid;
            }
    }

	if (!Data.resID || (p->fFlag & (OPEN_SILENT | OPEN_DATA))) {

		if (p->Flag & OPEN_DATA) 		/* data is provided - handle is ours */
        	DataPB.resData = p->Data;

        else {							/* no data, load default from editor */
        	DataPB.pCount = 6;
			DataPB.resType = p->resType;;
			DataPB.resID = 0x00030000L + (long) p->resType;
			DataPB.resFileID = edResFileID;
			resErr = fLoadResource(&DataPB);
        	RefPB.pCount = 3;
			RefPB.resType = p->resType;
			RefPB.resID = 0x00030000L + (long) p->resType;
			RefPB.resFileID = edResFileID;
			resErr = fDetachResource(&DataPB);
		}
        DataPB.pCount = 4;
		DataPB.resID = p->resID;		/* if null, then Add returns ID added */
		DataPB.special = 0;				/* no attributes assigned */
		resErr = fAddResource(&DataPB);
        p->resID = DataPB.resID;		/* this may change so pass it back */
        if (p->flag & OPEN_SILENT) {
        	RefPB.pCount = 2;
			RefPB.resType = p->resType;
			RefPB.resID = DataPB.resID;
			resErr = fReleaseResource(&DataPB);
           	return 0;
        }
	}
    switch (p->resType) {
        case rWindParam1:
            {
                winTempID = 0x0500L;
                windKind = 0;
                break;
            }
        case rControlList:
            {
                winTempID = 0x0550L;
                windKind = 16;
                break;
            }
        case rControlTemplate:
            {
                ctlHndl = GetResData(p->resType, p->resID, 0);
                ctl.dummy = (Pointer) *ctlHndl;
                procRef = ctl.BcPtr->ctlTemplate.procRef;
                switch (procRef)
                    {
                        case simpleButtonControl:
                        {
                            winTempID = 0x10001L;
                            windKind = 4;
                            break;
                        }
                        case checkControl:
                        {
                            winTempID = 0x10002L;
                            windKind = 2;
                            break;
                        }
                        case iconButtonControl:
                        case 0x07ff0001:
                        {
                            winTempID = 0x10003L;
                            windKind = 5;
                            break;
                        }
                        case editLineControl:
                        {
                            winTempID = 0x10004L;
                            windKind = 12;
                            break;
                        }
                        case listControl:
                        {
                            winTempID = 0x10005L;
                            windKind = 6;
                            break;
                        }
                        case pictureControl:
                        {
                            winTempID = 0x10006L;
                            windKind = 13;
                            break;
                        }
                        case popUpControl:
                        {
                            winTempID = 0x10007L;
                            windKind = 7;
                            break;
                        }
                        case radioControl:
                        {
                            winTempID = 0x10008L;
                            windKind = 3;
                            break;
                        }
                        case scrollBarControl:
                        {
                            winTempID = 0x10009L;
                            windKind = 8;
                            break;
                        }
                        case growControl:
                        {
                            winTempID = 0x1000AL;
                            windKind = 9;
                            break;
                        }
                        case statTextControl:
                        {
                            winTempID = 0x1000BL;
                            windKind = 14;
                            break;
                        }
                        case editTextControl:
                        {
                            winTempID = 0x1000CL;
                            windKind = 10;
                            break;
                        }
                        case rectangleControl:
                        {
                            winTempID = 0x1000DL;
                            windKind = 15;
                            break;
                        }
                        case thermometerControl:
                        {
                            winTempID = 0x1000EL;
                            windKind = 11;
                            break;
                        }
		                default:
                        {
                            Data2PB.pCount = 5;
	                        Data2PB.resType = rAlertString;
	                        Data2PB.resID = 1L;
	                        Data2PB.special = 0;
	                        Data2PB.resFileID = edResFileID;
	                        resErr = fSpecialMagic(&DataPB);
                            action = AlertWindow(0x0032, 0L, DataPB.resData);
                            if (action) {
                                DataPB.pCount = 2;
                                DataPB.resType = p->resType;
                                DataPB.resID = p->resID;
                                fRequestEdit(&DataPB);
                                }
                            return;
                        }
                    }
                break;
            }

        case rCtlColorTbl:
            {
                windKind = 17;
                winTempID = 0x0600L;
                break;
            }
        case rWindColor:
            {
                windKind = 0x18;
                winTempID = 0x0300L;
                break;
            }

    case rMenuBar:
            {
                windKind = 19;
                winTempID = 0x0400L;
                break;
            }

    case rMenu:
            {
                windKind = 0x20;
                winTempID = 0x0200L;
                break;
            }
    case rMenuItem:
            {
                windKind = 0x21;
                winTempID = 0x0100L;
                break;
            }

    DataPB.pCount = 5;
	DataPB.resType = rWinParam1;
	DataPB.resID = winTempID;
	DataPB.special = 0;
	DataPB.resFileID = edResFileID;
	resErr = fSpecialMagic(&DataPB);

	title = NewHandle(128L, edUserID, 0x8018, 0L);

	NamePB.Pcount = 3;
	NamePB.resType = pString;
	NamePB.resID = p->resID;
	NamePB.resName = (Pointer) *title;
	resErr = fGetWindowTitle(&NamePB);

    (Handle) private = NewHandle(90L, edUserID, 0x0018, 0L);
    pPtr = deref(private);
    pPtr->winP = NewWindow2(*title, 0L, 0L, 0L, 1, winTempID, 0x800e);
	pPtr->shortKind = windKind;
    AdjustWindow(pPtr->winP);
    PrivPB.pCount = 7;
	PrivPB.winPtr = pPtr->winP;
	PrivPB.TaskMask = 0L;		/* use standard task mask */
	PrivPB.remSignature = 0;    /* my personal signature - no significance */
	PrivPB.Data = private;
    PrivPB.groupSignature = 0x0020;
    PrivPB.resType = p->resType;
    PrivPB.resID = p->resID;
    fAddPrivateData(&PrivPB);

    pPtr->dirty = 0;
    pPtr->data = GetResData(p->resType, p->resID, 0);  /* we now have a valid copy */
    											 /* of our raw res data here */
	pPtr->title = title;

    switch (windKind) {
        case 00:      /* Window */
            {
	            pPtr->edTempH = (WinTemplateHndl) NewHandle(80L, edUserID, 0x8018, 0L);
	            pPtr->wkTempH = (WinTemplateHndl) NewHandle(80L, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, 80L);
                HandToHand(pPtr->data, pPtr->wkTempH, 80L);
                edWin = deref(pPtr->edTempH);
                wkWin = deref(pPtr->wkTempH);
                if (!edWin->plControlList)
                    SetWindMenu (0, pPtr->winP);
                pPtr->edTempH = (WinTemplateHndl) GetResData(p->resType, p->resID, 0);
                if bad
                    ;  /* perhaps put error alert here? */
                if ((edWin->plInDesc & 0xFF) == 9) {  /* ControlList Exists */
                    pPtr->wkCtlListH = (Handle) GetWkCtlList(edWin->plControlList);
                    wkWin->plControlList = pPtr->wkCtlListH;
                    wkWin->plInDesc &= 0xFF00;
                    wkWin->plInDesc |= 7;
                }
                if ((edWin->plInDesc & 0xFF) == 2) {  /* SingleControlExists */
                    pPtr->wkCtlListH = (Handle) GetWkCtl(edWin->plControlList);
                    wkWin->plControlList = pPtr->wkCtlListH;
                    wkWin->plInDesc &= 0xFF00;
                    wkWin->plInDesc |= 1;
                }
                if (edWin->plInDesc & 0x800) {  /* ColTableResource Exists */
                    wkWin->plColor = GetWinClrs(edWin->plColor);
                    wkWin->plInDesc &= 0xF3FF;
                    wkWin->plInDesc |= 0x0400;
                }
                if (edWin->plInDesc & 0x200)  Title Exists
                    wkWin->plTitle = GetWinTit(edWin->plTitle);
                    wkWin->plInDesc &= 0xFCFF;
                    wkWin->plInDesc |= 0x0100;
                }
                pPtr->edP = NewWindow2(0L, 0L, &EditWinProc, 0L, 1, pPtr->wkTempH, 0x800e);
                /* still need to set the local refcon */
                SetWorkingData(pPtr->winP, 0);
                break;
            }

        case 02:      /* Check Box */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1002,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.CBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.CBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.CBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (!wkCtl.CBcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.CBcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.CBcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText, tempName);
                SetLETextByID(winP, 0x1008L, tempText); /* setting title */
                if (wkCtl.CBcPtr->initialValue)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1010L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1010L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 03:      /* Radio Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1008,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.CBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.CBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.CBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (!wkCtl.CBcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.CBcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.CBcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText, tempName);
                SetLETextByID(winP, 0x1008L, tempText); /* setting title */
                if (wkCtl.CBcPtr->initialValue)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1010L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1010L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 04:      /* Simple Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1001,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.BcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.BcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.BcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                SetCtlValue(1101 + (wkCtl.BcPtr->ctlTemplate.flag & 3),
                    GetCtlHandleFromID(winP, 0x1002L)); /* set button type */
                if (!wkCtl.BcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.BcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.BcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText, tempName);
                SetLETextByID(winP, 0x1008L, tempText); /* setting title */
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 05:      /* Icon Button */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1003,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.IcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.IcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.IcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                SetCtlValue(1101 + (wkCtl.IcPtr->ctlTemplate.flag & 3),
                    GetCtlHandleFromID(winP, 0x1002L)); /* set button type */
                if (!wkCtl.IcPtr->keyEquivalent)
                    SetCtlValue(1 ,GetCtlHandleFromID(winP, 0x1003L));
                else                /* setting key equivs CB */
                    SetCtlValue(0 ,GetCtlHandleFromID(winP, 0x1003L));
                if (wkCtl.IcPtr->titleRef)
                    tempName = deref(GetResData(rPString, wkCtl.IcPtr->titleRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText, tempName);
                SetLETextByID(winP, 0x1008L, tempText); /* setting title */
                if (wkCtl.IcPtr->ctlTemplate.flag & 0x4)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1009L));
                else                /* setting show border checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1009L));
                if (wkCtl.IcPtr->ctlTemplate.flag & 0xFF00)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x100AL));
                else                /* setting inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x100AL));
                if (wkCtl.IcPtr->displayMode)
                    {
                    if (wkCtl.IcPtr->displayMode & 4)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100DL));
                    else                /* setting offline checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100DL));
                    if (wkCtl.IcPtr->displayMode & 2)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100EL));
                    else                /* setting openIcon checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100EL));
                    if (wkCtl.IcPtr->displayMode & 1)
                        SetCtlValue(1, GetCtlHandleFromID(winP, 0x100FL));
                    else                /* setting selectedIcon checkbox */
                        SetCtlValue(0, GetCtlHandleFromID(winP, 0x100FL));
	            	pPtr->MasterColor[1] = (wkCtl.IcPtr->displayMode & 0xf000) >> 12;
	            	pPtr->MasterColor[0] = (wkCtl.IcPtr->displayMode & 0xf00) >> 8;
                    }
                else
                    {
	            	pPtr->MasterColor[1] = 0xf;
	            	pPtr->MasterColor[0] = 0;
                    }
				DrawClrCtls(12);
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 06:      /* List Control */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1005,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.LcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.LcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.LcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                sprintf(tempText, "%0.2u", wkCtl.LcPtr->listMemHeight);
                SetLETextByID(winP, 0x1018L, tempText); /* setting title */
                if (wkCtl.LcPtr->listType & 0x2)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1015L));
                else                /* setting multiselect checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1015L));
                if (wkCtl.LcPtr->listType & 0x4)
                    SetCtlValue(0x1601, GetCtlHandleFromID(winP, 0x1016L));
                else                /* setting multiselect checkbox */
                    SetCtlValue(0x1602, GetCtlHandleFromID(winP, 0x1016L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 07:      /* PopUp Menu */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1007,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.PmcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.PMcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0xFF00)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x100AL));
                else                /* setting inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x100AL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101DL));
                else                /* setting white space checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101DL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x20)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101EL));
                else                /* setting hilite title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101EL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x4)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x101FL));
                else                /* setting keep in window checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x101FL));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x8)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1020L));
                else                /* setting show selection checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1020L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x10)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1021L));
                else                /* setting Draw Title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1021L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x2)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1022L));
                else                /* setting RtJust Title checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1022L));
                if (wkCtl.PMcPtr->ctlTemplate.flag & 0x1)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1023L));
                else                /* setting RtJust Select checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1023L));
                sprintf(tempText, "%0.3u", wkCtl.PmcPtr->titleWidth);
                SetLETextByID(winP, 0x1025L, tempText); /* setting title width */
                sprintf(tempText, "%0.5u", wkCtl.PmcPtr->initialValue);
                SetLETextByID(winP, 0x1027L, tempText); /* setting selected item */
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 08:      /* Scroll Bar */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1009, GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.SBcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.SBcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.SBcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.SBcPtr->ctlTemplate.flag & 10)
                    temp = 0x1701;
                else
                    temp = 0x1702;
                if (wkCtl.SBcPtr->ctlTemplate.flag & 0xF)
                    temp += 2;
                SetCtlValue(temp, GetCtlHandleFromID(winP,0x1029L));
                sprintf(tempText, "%0.5u", wkCtl.SBcPtr->maxSize);
                SetLETextByID(winP, 0x102BL, tempText); /* initial page */
                sprintf(tempText, "%0.5u", wkCtl.SBcPtr->viewSize);
                SetLETextByID(winP, 0x102BL, tempText); /* initial value */
                sprintf(tempText, "%0.5u", wkCtl.SBcPtr->initialValue);
                SetLETextByID(winP, 0x102BL, tempText); /* initial value */
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 09:      /* Grow Box */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(100A, GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.GcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.GcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.GcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.GcPtr->ctlTemplate.flag & 0x1)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1030L));
                else                /* setting CallWindMgr checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1030L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 10:      /* Edit Text */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(0x100C, GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.TEcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.TEcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.TEcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.TEcPtr->textFlags & 0x20000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1034L));
                else                /* setting one style checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1034L));
                if (wkCtl.TEcPtr->textFlags & 0x10000000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1035L));
                else                /* setting word wrap checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1035L));
                if (wkCtl.TEcPtr->textFlags & 0x8000000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1036L));
                else                /* setting scrolling checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1036L));
                if (wkCtl.TEcPtr->textFlags & 0x4000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1037L));
                else                /* setting Read Only checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1037L));
                if (wkCtl.TEcPtr->textFlags & 0x1000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1038L));
                else                /* setting TabNextCtl checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1038L));
                if (wkCtl.TEcPtr->textFlags & 0x800000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1039L));
                else                /* setting Draw Frame checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1039L));
                if (wkCtl.TEcPtr->textFlags & 0x2000000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103DL));
                else                /* setting Smart Cut/Paste checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103DL));
                if (wkCtl.TEcPtr->textFlags & 0x200000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103AL));
                else                /* setting Grow Ruler checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103AL));
                if (wkCtl.TEcPtr->textFlags & 0x100000L)
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103BL));
                else                /* setting Enable Selection checkbox */
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103BL));
                if (wkCtl.TEcPtr->textFlags & 0x80000L)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x103CL));
                else                /* setting Box Inactive checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x103CL));

                if (wkCtl.TEcPtr->vertAmount)
                	tempVal = wkCtl.TEcPtr->vertAmount;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.4X", tempVal);
                SetLETextByID(winP, 0x11041L, tempText);

                if (wkCtl.TEcPtr->maxChars)
                	tempVal = wkCtl.TEcPtr->maxChars;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.8X", tempVal);
                SetLETextByID(winP, 0x11044L, tempText);

				tempVal = 0x1A01;
                if (wkCtl.TEcPtr->drawMode)	{
    				switch (wkCtl.TEcPtr->drawMode) {
        				case modeForeCopy: {
				        	tempVal = 0x1A01;
					        break;
					        }
        				case modeForeOR: {
				        	tempVal = 0x1A03;
					        break;
					        }
        				case modeForeXOR: {
				        	tempVal = 0x1A05;
					        break;
					        }
        				case modeForeBIC: {
				        	tempVal = 0x1A07;
					        break;
					        }
        				case notForeCopy: {
				        	tempVal = 0x1A02;
					        break;
					        }
        				case notForeOR: {
				        	tempVal = 0x1A04;
					        break;
					        }
        				case notForeXOR: {
				        	tempVal = 0x1A06;
					        break;
					        }
        				case notForeBIC: {
				        	tempVal = 0x1A08;
					        break;
					        }
					}
				}
                SetCtlValue(tempVal, GetCtlHandleFromID(winP, 0x1042L));
				SetWorkingData(pPtr->winP, 0);
				break;
			}

        case 11:      /* Thermometer */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(100D,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.TcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.TcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.TcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));

				tempVal = (wkCtl.TcPtr->ctlTemplate.flag & 1) ? 0x1B01 : 0x1B02;
                SetCtlValue(tempVal, GetCtlHandleFromID(winP, 0x1000L));

                if (wkCtl.TcPtr->data)
                	tempVal = wkCtl.TcPtr->data;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.4X", tempVal);
                SetLETextByID(winP, 0x11048L, tempText);

                if (wkCtl.TcPtr->value)
                	tempVal = wkCtl.TcPtr->value;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.4X", tempVal);
                SetLETextByID(winP, 0x1104AL, tempText);
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 12:      /* Edit Line */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1004,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.LEcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.LEcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.LEcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                if (wkCtl.LEcPtr->defaultRef)
                    tempName = deref(GetResData(rPString, wkCtl.LEcPtr->defaultRef, 0));
                else
                    tempName[0] = 0;
                strcpy(tempText, tempName);
                SetLETextByID(winP, 0x1012L, tempText); /* setting title */
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 13:      /* Picture */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(1006,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.PcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.PcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.PcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 14:      /* Static Text */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(0x100B, GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.STcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.STcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.STcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));
                temp = 0x1801;
                if (wkCtl.STcPtr->just)
                    {
                    if (wkCtl.STcPtr->just == 1)
                        temp = 0x1802;
                    if (wkCtl.STcPtr->just == -1)
                        temp = 0x1803;
                    if (wkCtl.STcPtr->just == 2)
                        temp = 0x1804;
                    }
                SetCtlValue(temp, GetCtlHandleFromID(winP, 0x1031L));
                temp = 0x1901;
                if (wkCtl.STcPtr->ctlTemplate.flag & 2)
                    {
                    if (wkCtl.STcPtr->ctlTemplate.flag & 1)
                        temp = 0x1903;
                    else
                        temp = 0x1902;
                    }
                SetCtlValue(temp, GetCtlHandleFromID(winP, 0x1032L));
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 15:      /* Rectangle */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
	            pPtr->wkCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edCtlListH, hansize);
                HandToHand(pPtr->data, pPtr->wkCtlListH, hansize);
                pPtr->wkCtlListH = (Handle) GetWkCtl(p->resID);
                wkCtl = (control) deref(wkCtl);
                SetCtlValue(100E,GetCtlHandleFromID(winP, 0x1000L));
                sprintf(tempText, "%0.8lX", wkCtl.RcPtr->ctlTemplate.ID);
                SetLETextByID(winP, 0x3000L, tempText); /* setting ID */
                sprintf(tempText, "%0.8lX", wkCtl.RcPtr->ctlTemplate.refCon);
                SetLETextByID(winP, 0x5000L, tempText); /* setting refCon */
                if (wkCtl.RcPtr->ctlTemplate.flag & 0x40)
                    SetCtlValue(1, GetCtlHandleFromID(winP, 0x1001L));
                else                /* setting invisible checkbox */
                    SetCtlValue(0, GetCtlHandleFromID(winP, 0x1001L));

				switch (wkCtl.RcPtr->ctlTemplate.flag & 3) {
					case 0: {
						tempVal = 0x1C03;
						break;
						}
					case 1: {
						tempVal = 0x1C02;
						break;
						}
					case 2: {
						tempVal = 0x1C01;
						break;
						}
					}
				if (wkCtl.RcPtr->penPattern) {
					tempVal = 0x1C04;
                    HiliteControl(0, GetCtlHandleFromID(winP, 0x1051L));
                    }
				else
					HiliteControl(255, GetCtlHandleFromID(winP, 0x1051L));
                SetCtlValue(tempVal, GetCtlHandleFromID(winP, 0x1104L));
                if (wkCtl.RcPtr->penHeight)
                	tempVal = wkCtl.RcPtr->penHeight;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.4X", tempVal);
                SetLETextByID(winP, 0x1104EL, tempText);
                if (wkCtl.RcPtr->penWidth)
                	tempVal = wkCtl.RcPtr->penWidth;
	            else
	            	tempVal = 0;
                sprintf(tempText, "%0.4X", tempVal);
                SetLETextByID(winP, 0x11050L, tempText);
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 16:      /* Control List */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, hansize);

                SetWindMenu (0, pPtr->winP);
                pPtr->edP = NewWindow2(0L, 0L, &EditWinProc, 0L, 1, 0x0555L, 0x800e);
                AdjustWindow(pPtr->edP);
                wkPtr = deref(pPtr->wkCtlListH);
                for (i = 0; wkPtr[i] != 0L; i++)
                    tempCtl = NewControl2(pPtr->edP, 1, wkPtr[i]);
                SetWorkingData(pPtr->winP, 0);
                break;
            }

        case 17:      /* Control Color */
            {
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, hansize);
 				parentRec.pCount = 6;
				parentRec.resType = rCtlColorTbl;
				parentRec.resID = p->resID;
				fFindHostLink(&parentRec);
				pPtr->parentID = parentRec.hostID;
                ctlHndl = GetResData(rControlTemplate, parentRec.hostID, 0);
                ctl.dummy = (Pointer) *ctlHndl;
                procRef = ctl.BcPtr->ctlTemplate.procRef;
                switch (procRef)
                    {
                        case simpleButtonControl:
                        {
                            pPtr->parentKind = 4;
                            break;
                        }
                        case checkControl:
                        {
                            pPtr->parentKind = 2;
                            break;
                        }
                        case iconButtonControl:
                        case 0x07ff0001:
                        {
                            pPtr->parentKind = 5;
                            break;
                        }
                        case editLineControl:
                        {
                            pPtr->parentKind = 12;
                            break;
                        }
                        case listControl:
                        {
                            pPtr->parentKind = 6;
                            break;
                        }
                        case pictureControl:
                        {
                            pPtr->parentKind = 13;
                            break;
                        }
                        case popUpControl:
                        {
                            pPtr->parentKind = 7;
                            break;
                        }
                        case radioControl:
                        {
                            pPtr->parentKind = 3;
                            break;
                        }
                        case scrollBarControl:
                        {
                            pPtr->parentKind = 8;
                            break;
                        }
                        case growControl:
                        {
                            pPtr->parentKind = 9;
                            break;
                        }
                        case statTextControl:
                        {
                            pPtr->parentKind = 14;
                            break;
                        }
                        case editTextControl:
                        {
                            pPtr->parentKind = 10;
                            break;
                        }
                        case rectangleControl:
                        {
                            pPtr->parentKind = 15;
                            break;
                        }
                        case thermometerControl:
                        {
                            pPtr->parentKind = 11;
                            break;
                        }
                    }
                GetMasterColors(pPtr->parentKind);
                DrawClrCtls(pPtr->parentKind);
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 18:      /* Window Color */
                hansize = GetHandleSize(pPtr->data);
	            pPtr->edCtlListH = NewHandle(hansize, edUserID, 0x8018, 0L);
                HandToHand(pPtr->data, pPtr->edTempH, hansize);
 				parentRec.pCount = 6;
				parentRec.resType = rWindColor;
				parentRec.resID = p->resID;
				fFindHostLink(&parentRec);
				pPtr->parentID = parentRec.hostID;
                edTempH = (WinTemplateHndl) GetResData(rWindParam1, parentRec.hostID, 0);
                edWin = (Pointer) *ctlHndl;
				pPtr->parentKind = 0;
				if (edWin->wFrameBits & 0x2000)
					pPtr->parentKind = 1;
                GetMasterColors(pPtr->parentKind);
                DrawClrCtls(pPtr->parentKind);
				SetWorkingData(pPtr->winP, 0);
				break;
            }

        case 19:      /* MenuBar */
            {
            }

        case 20:      /* Menu */
            {
            }
        case 21:      /* MenuItem */
            {
            }
        }

	SetFrameColor(p->winColorPtr, winP);
	ShowWindow(winP);
    return  0;
}
